%getlights
%
%	Get lighting environment rendering parameters by name
%
% -Usage-
%	L = getlights(name)
%
% -Inputs-
%	name
%
% -Outputs-
%	L
%
% Last Modified: 06/20/2011
function L = getlights(name)

	L = feval(sprintf('do_%s',name));

end





function L = do_doge1()

	L(1).A(1,:) = [-0.005896293  0.003201143  0.000909221];
	L(1).A(2,:) = [0.003201143  0.007083686  -0.002286545];
	L(1).A(3,:) = [0.000909221  -0.002286545  0.034119957];
	L(1).b      = [-0.227557077  -0.047123300  0.205254578]';
	L(1).c      = 0.673823976;

	L(2).A(1,:) = [-0.006897805  0.002766256  0.003926461];
	L(2).A(2,:) = [0.002766256  0.008716128  -0.001902301];
	L(2).A(3,:) = [0.003926461  -0.001902301  0.032048057];
	L(2).b      = [-0.234017921  -0.046864423  0.214483105]';
	L(2).c      = 0.650575084;

	L(3).A(1,:) = [-0.007922342  0.002600586  0.007483184];
	L(3).A(2,:) = [0.002600586  0.010639797  -0.001596472];
	L(3).A(3,:) = [0.007483184  -0.001596472  0.029887898];
	L(3).b      = [-0.246965886  -0.047780764  0.229818354]';
	L(3).c      = 0.642377030;

end

function L = do_ennis1()

	L(1).A(1,:) = [0.012111410  -0.050209941  0.082911865];
	L(1).A(2,:) = [-0.050209941  -0.008771916  -0.073770604];
	L(1).A(3,:) = [0.082911865  -0.073770604  0.064292656];
	L(1).b      = [0.268156623  -0.231468888  -0.092379687]';
	L(1).c      = 0.534500303;

	L(2).A(1,:) = [0.005580419  -0.039059360  0.076710682];
	L(2).A(2,:) = [-0.039059360  -0.005798831  -0.069191851];
	L(2).A(3,:) = [0.076710682  -0.069191851  0.108942310];
	L(2).b      = [0.291239677  -0.248649799  -0.103024504]';
	L(2).c      = 0.519459171;

	L(3).A(1,:) = [0.003700585  -0.024066435  0.068039343];
	L(3).A(2,:) = [-0.024066435  -0.000245071  -0.062213242];
	L(3).A(3,:) = [0.068039343  -0.062213242  0.173030778];
	L(3).b      = [0.328558500  -0.279912895  -0.116023741]';
	L(3).c      = 0.523965610;

end

function L = do_galileo1()

	L(1).A(1,:) = [-0.017801086  -0.002528932  0.002100701];
	L(1).A(2,:) = [-0.002528932  0.049436090  -0.070054023];
	L(1).A(3,:) = [0.002100701  -0.070054023  0.029327239];
	L(1).b      = [0.074137283  -0.256315147  -0.011036427]';
	L(1).c      = 0.650065892;

	L(2).A(1,:) = [-0.015520624  -0.000988311  0.001280326];
	L(2).A(2,:) = [-0.000988311  0.039552486  -0.064856663];
	L(2).A(3,:) = [0.001280326  -0.064856663  0.027343945];
	L(2).b      = [0.072065339  -0.232968381  -0.015493363]';
	L(2).c      = 0.565609359;

	L(3).A(1,:) = [-0.017510204  0.001069329  0.002093243];
	L(3).A(2,:) = [0.001069329  0.040051463  -0.066665272];
	L(3).A(3,:) = [0.002093243  -0.066665272  0.032712034];
	L(3).b      = [0.071248006  -0.244605277  -0.017607277]';
	L(3).c      = 0.547544948;

end

function L = do_grace1()

	L(1).A(1,:) = [-0.006386792  -0.066426750  -0.016467643];
	L(1).A(2,:) = [-0.066426750  0.096501242  0.008511092];
	L(1).A(3,:) = [-0.016467643  0.008511092  0.006621771];
	L(1).b      = [0.180982477  -0.116395735  0.157892438]';
	L(1).c      = 0.644349099;

	L(2).A(1,:) = [-0.005136530  -0.034599459  -0.022645629];
	L(2).A(2,:) = [-0.034599459  0.050913648  0.007954372];
	L(2).A(3,:) = [-0.022645629  0.007954372  0.005830306];
	L(2).b      = [0.153049170  -0.033677028  0.199819068]';
	L(2).c      = 0.507149966;

	L(3).A(1,:) = [-0.000083743  -0.017706923  -0.034978499];
	L(3).A(2,:) = [-0.017706923  0.051151574  0.000809860];
	L(3).A(3,:) = [-0.034978499  0.000809860  0.000393592];
	L(3).b      = [0.221037033  -0.007065085  0.336310785]';
	L(3).c      = 0.546605789;

end

function L = do_hallstatt1()

	L(1).A(1,:) = [0.080655475  -0.008675367  -0.017502297];
	L(1).A(2,:) = [-0.008675367  0.025027589  0.014005760];
	L(1).A(3,:) = [-0.017502297  0.014005760  -0.019579120];
	L(1).b      = [-0.087676109  -0.137579861  0.073267221]';
	L(1).c      = 0.695467376;

	L(2).A(1,:) = [0.023873863  -0.017821676  -0.014102468];
	L(2).A(2,:) = [-0.017821676  0.020052658  0.000198895];
	L(2).A(3,:) = [-0.014102468  0.000198895  -0.010885869];
	L(2).b      = [-0.113143438  -0.180685304  0.091933587]';
	L(2).c      = 0.690953399;

	L(3).A(1,:) = [0.004072301  -0.022971944  -0.009826165];
	L(3).A(2,:) = [-0.022971944  0.020993442  -0.002971898];
	L(3).A(3,:) = [-0.009826165  -0.002971898  -0.003251203];
	L(3).b      = [-0.129431137  -0.213007432  0.114269544]';
	L(3).c      = 0.710660373;

end

function L = do_pisa1()

	L(1).A(1,:) = [-0.018197237  0.003928759  -0.053390933];
	L(1).A(2,:) = [0.003928759  0.026131558  0.002353613];
	L(1).A(3,:) = [-0.053390933  0.002353613  0.056127668];
	L(1).b      = [0.255615787  -0.087719537  0.065943939]';
	L(1).c      = 0.735447091;

	L(2).A(1,:) = [-0.004611826  -0.009625583  -0.068081238];
	L(2).A(2,:) = [-0.009625583  0.005085290  0.014261679];
	L(2).A(3,:) = [-0.068081238  0.014261679  0.047852618];
	L(2).b      = [0.264989140  -0.070414285  -0.063984080]';
	L(2).c      = 0.655478338;

	L(3).A(1,:) = [0.019828443  -0.021276780  -0.076124542];
	L(3).A(2,:) = [-0.021276780  -0.005048076  0.032215578];
	L(3).A(3,:) = [-0.076124542  0.032215578  0.006778990];
	L(3).b      = [0.310108029  -0.063026713  -0.146094913]';
	L(3).c      = 0.610976003;

end

function L = do_rnl1()

	L(1).A(1,:) = [-0.005619010  0.011441738  -0.007198348];
	L(1).A(2,:) = [0.011441738  0.032092440  -0.008783427];
	L(1).A(3,:) = [-0.007198348  -0.008783427  0.007183139];
	L(1).b      = [-0.020018163  -0.067281480  0.174038742]';
	L(1).c      = 0.653516665;

	L(2).A(1,:) = [-0.005608544  0.009445768  -0.006612588];
	L(2).A(2,:) = [0.009445768  0.036300972  -0.007465187];
	L(2).A(3,:) = [-0.006612588  -0.007465187  0.006902567];
	L(2).b      = [-0.007520214  -0.058858357  0.211400648]';
	L(2).c      = 0.690059238;

	L(3).A(1,:) = [-0.005004719  0.006633762  -0.007077132];
	L(3).A(2,:) = [0.006633762  0.037724760  -0.006278988];
	L(3).A(3,:) = [-0.007077132  -0.006278988  0.005747714];
	L(3).b      = [0.012622305  -0.043491958  0.247851945]';
	L(3).c      = 0.707253931;

end

function L = do_tunnel1()

	L(1).A(1,:) = [-0.031947477  0.092187513  -0.044417987];
	L(1).A(2,:) = [0.092187513  0.056204217  0.054011566];
	L(1).A(3,:) = [-0.044417987  0.054011566  0.070906338];
	L(1).b      = [-0.069138870  -0.210542760  -0.150448808]';
	L(1).c      = 0.692004153;

	L(2).A(1,:) = [-0.028756605  0.087709650  -0.043613482];
	L(2).A(2,:) = [0.087709650  0.049884710  0.047667767];
	L(2).A(3,:) = [-0.043613482  0.047667767  0.065261777];
	L(2).b      = [-0.069057653  -0.191799878  -0.139008613]';
	L(2).c      = 0.689610500;

	L(3).A(1,:) = [-0.026959227  0.077052332  -0.027785565];
	L(3).A(2,:) = [0.077052332  0.049653687  0.059365414];
	L(3).A(3,:) = [-0.027785565  0.059365414  0.055822116];
	L(3).b      = [-0.060636877  -0.169709745  -0.129743550]';
	L(3).c      = 0.626383065;

end

function L = do_uffizi1()

	L(1).A(1,:) = [-0.035211042  -0.002998696  0.000390465];
	L(1).A(2,:) = [-0.002998696  0.110474161  0.027355978];
	L(1).A(3,:) = [0.000390465  0.027355978  0.046945260];
	L(1).b      = [0.001282535  -0.356246772  0.021023192]';
	L(1).c      = 0.486593530;

	L(2).A(1,:) = [-0.035199755  -0.002846934  0.000444962];
	L(2).A(2,:) = [-0.002846934  0.109094545  0.027936141];
	L(2).A(3,:) = [0.000444962  0.027936141  0.047086742];
	L(2).b      = [0.001128902  -0.361549800  0.021509291]';
	L(2).c      = 0.476471209;

	L(3).A(1,:) = [-0.037885705  -0.002957971  0.000475550];
	L(3).A(2,:) = [-0.002957971  0.117160869  0.030693723];
	L(3).A(3,:) = [0.000475550  0.030693723  0.050647660];
	L(3).b      = [0.001627090  -0.394797279  0.022316244]';
	L(3).c      = 0.500439197;

end

function L = do_window1()

	L(1).A(1,:) = [0.052687646  0.028564006  -0.027740506];
	L(1).A(2,:) = [0.028564006  0.086437782  0.010573064];
	L(1).A(3,:) = [-0.027740506  0.010573064  -0.034355417];
	L(1).b      = [-0.000999934  -0.256816025  0.013982959]';
	L(1).c      = 0.635663877;

	L(2).A(1,:) = [0.047177654  0.011268911  -0.030962870];
	L(2).A(2,:) = [0.011268911  0.053178857  -0.016736549];
	L(2).A(3,:) = [-0.030962870  -0.016736549  -0.026042036];
	L(2).b      = [0.019788852  -0.304913884  0.008445878]';
	L(2).c      = 0.585363575;

	L(3).A(1,:) = [0.038764975  -0.001451573  -0.030090214];
	L(3).A(2,:) = [-0.001451573  0.010977947  -0.037922853];
	L(3).A(3,:) = [-0.030090214  -0.037922853  -0.008557141];
	L(3).b      = [0.034861844  -0.334996039  -0.003117086]';
	L(3).c      = 0.573899319;

end


%
% RGB Photometric stereo lighting
%
function L = do_ps3()

	L(1).A(1,:) = [-0.130747755  -0.000010773  -0.000018301];
	L(1).A(2,:) = [-0.000010773  0.182482182  -0.296873372];
	L(1).A(3,:) = [-0.000018301  -0.296873372  0.219828413];
	L(1).b      = [0.000053709  -0.326467469  0.039184295]';
	L(1).c      = 0.271562840;

	L(2).A(1,:) = [0.103918486  -0.135565526  -0.257147590];
	L(2).A(2,:) = [-0.135565526  -0.052646791  0.148507704];
	L(2).A(3,:) = [-0.257147590  0.148507704  0.221026742];
	L(2).b      = [-0.282669130  0.163108182  0.037456715]';
	L(2).c      = 0.272298437;

	L(3).A(1,:) = [0.103999302  0.135572766  0.257071610];
	L(3).A(2,:) = [0.135572766  -0.052603015  0.148493383];
	L(3).A(3,:) = [0.257071610  0.148493383  0.220741787];
	L(3).b      = [0.282788447  0.163105483  0.037816729]';
	L(3).c      = 0.272138074;

end

%
% Used lambda = 0.01 in optimization
%
function L = do_toys1_4115()

	L(1).A(1,:) = [0.181810064  -0.040221317  -0.015155626];
	L(1).A(2,:) = [-0.040221317  0.140100484  -0.036658652];
	L(1).A(3,:) = [-0.015155626  -0.036658652  0.088703929];
	L(1).b      = [-0.045985929  -0.107224627  0.144245161]';
	L(1).c      = 0.416673579;

	L(2).A(1,:) = [0.162459611  -0.020991249  -0.037708874];
	L(2).A(2,:) = [-0.020991249  0.110558335  -0.029354121];
	L(2).A(3,:) = [-0.037708874  -0.029354121  0.075562482];
	L(2).b      = [-0.096396831  -0.085598922  0.145836220]';
	L(2).c      = 0.352698235;

	L(3).A(1,:) = [0.128161534  0.001973607  -0.054978710];
	L(3).A(2,:) = [0.001973607  0.076331910  -0.023613729];
	L(3).A(3,:) = [-0.054978710  -0.023613729  0.095214325];
	L(3).b      = [-0.169827293  -0.058891511  0.119435043]';
	L(3).c      = 0.301688411;

end

%
%
%
function L = do_toys1_4115_old()

	L(1).A(1,:) = [0.072425862  -0.040219674  -0.015158416];
	L(1).A(2,:) = [-0.040219674  0.030717136  -0.036660795];
	L(1).A(3,:) = [-0.015158416  -0.036660795  -0.020535674];
	L(1).b      = [-0.045981818  -0.107220954  0.144071336]';
	L(1).c      = 0.526100663;

	L(2).A(1,:) = [0.072296964  -0.020990028  -0.037710824];
	L(2).A(2,:) = [-0.020990028  0.020397060  -0.029356431];
	L(2).A(3,:) = [-0.037710824  -0.029356431  -0.014466581];
	L(2).b      = [-0.096393389  -0.085595127  0.145675792]';
	L(2).c      = 0.442900221;

	L(3).A(1,:) = [0.046563815  0.001973521  -0.054981109];
	L(3).A(2,:) = [0.001973521  -0.005263051  -0.023616040];
	L(3).A(3,:) = [-0.054981109  -0.023616040  0.013654929];
	L(3).b      = [-0.169823400  -0.058888077  0.119389883]';
	L(3).c      = 0.383295986;

end


%
% lambda = 0.01
%
function L = do_toys2_elevator()

	L(1).A(1,:) = [0.220008201  0.012025364  0.012636144];
	L(1).A(2,:) = [0.012025364  0.194261728  -0.006034289];
	L(1).A(3,:) = [0.012636144  -0.006034289  0.150478573];
	L(1).b      = [0.038395879  -0.056238503  0.078713565]';
	L(1).c      = 0.577691119;

	L(2).A(1,:) = [0.190842279  0.034815052  0.020287254];
	L(2).A(2,:) = [0.034815052  0.157888240  -0.005983817];
	L(2).A(3,:) = [0.020287254  -0.005983817  0.153329331];
	L(2).b      = [0.109084432  -0.111411701  0.105741326]';
	L(2).c      = 0.516577810;

	L(3).A(1,:) = [0.158061760  0.075083941  0.033735744];
	L(3).A(2,:) = [0.075083941  0.126814736  0.010995541];
	L(3).A(3,:) = [0.033735744  0.010995541  0.178768782];
	L(3).b      = [0.213383981  -0.177355226  0.113684468]';
	L(3).c      = 0.474211871;

end



%
%
%
function L = do_toys2_elevator_old()

	L(1).A(1,:) = [0.052064513  0.012023412  0.012638353];
	L(1).A(2,:) = [0.012023412  0.026318460  -0.006038604];
	L(1).A(3,:) = [0.012638353  -0.006038604  -0.017252101];
	L(1).b      = [0.038391872  -0.056232188  0.078457413]';
	L(1).c      = 0.745698352;

	L(2).A(1,:) = [0.035748834  0.034812878  0.020290231];
	L(2).A(2,:) = [0.034812878  0.002797916  -0.005989865];
	L(2).A(3,:) = [0.020290231  -0.005989865  -0.001650556];
	L(2).b      = [0.109079541  -0.111403545  0.105605657]';
	L(2).c      = 0.671703594;

	L(3).A(1,:) = [0.022771683  0.075082115  0.033739909];
	L(3).A(2,:) = [0.075082115  -0.008472802  0.010985581];
	L(3).A(3,:) = [0.033739909  0.010985581  0.043483733];
	L(3).b      = [0.213377982  -0.177343109  0.113679168]';
	L(3).c      = 0.609501876;

end


%
% lambda = 0.01
%
function L = do_toys2_hallway()

	L(1).A(1,:) = [0.116488648  -0.025722373  -0.013024425];
	L(1).A(2,:) = [-0.025722373  0.103890200  -0.014935689];
	L(1).A(3,:) = [-0.013024425  -0.014935689  0.113428809];
	L(1).b      = [-0.124350306  -0.259867245  0.133753349]';
	L(1).c      = 0.337246706;

	L(2).A(1,:) = [0.085322594  -0.021408203  -0.014590868];
	L(2).A(2,:) = [-0.021408203  0.110904615  -0.042091287];
	L(2).A(3,:) = [-0.014590868  -0.042091287  0.068658871];
	L(2).b      = [-0.175934371  -0.244409751  0.165240599]';
	L(2).c      = 0.266461271;

	L(3).A(1,:) = [0.106302818  -0.024656245  -0.013516553];
	L(3).A(2,:) = [-0.024656245  0.097252642  -0.051758307];
	L(3).A(3,:) = [-0.013516553  -0.051758307  0.001796715];
	L(3).b      = [-0.218762534  -0.203212917  0.212777853]';
	L(3).c      = 0.205244760;

end

%
%
%
function L = do_toys2_hallway_old()

	L(1).A(1,:) = [0.010331790  -0.025719994  -0.013029298];
	L(1).A(2,:) = [-0.025719994  -0.002262741  -0.014940724];
	L(1).A(3,:) = [-0.013029298  -0.014940724  0.007328989];
	L(1).b      = [-0.124343052  -0.259859717  0.133685006]';
	L(1).c      = 0.443419024;

	L(2).A(1,:) = [0.010552945  -0.021406549  -0.014597214];
	L(2).A(2,:) = [-0.021406549  0.036133041  -0.042094858];
	L(2).A(3,:) = [-0.014597214  -0.042094858  -0.005971298];
	L(2).b      = [-0.175925623  -0.244403879  0.165070544]';
	L(2).c      = 0.341274401;

	L(3).A(1,:) = [0.068623221  -0.024654419  -0.013684949];
	L(3).A(2,:) = [-0.024654419  0.059573113  -0.051550762];
	L(3).A(3,:) = [-0.013684949  -0.051550762  -0.035673178];
	L(3).b      = [-0.218564901  -0.203453090  0.212525597]';
	L(3).c      = 0.242986986;

end



%
% lambda = 0.001
%
function L = do_toys2_atrium()

	L(1).A(1,:) = [0.049220010  -0.020221629  0.001599496];
	L(1).A(2,:) = [-0.020221629  0.020293221  -0.008404551];
	L(1).A(3,:) = [0.001599496  -0.008404551  -0.160580149];
	L(1).b      = [0.038703161  -0.111926483  0.142577188]';
	L(1).c      = 0.579907789;

	L(2).A(1,:) = [0.127741972  -0.043251295  0.021183314];
	L(2).A(2,:) = [-0.043251295  0.141835133  -0.024282665];
	L(2).A(3,:) = [0.021183314  -0.024282665  -0.143021739];
	L(2).b      = [0.116853519  -0.134907595  0.210826666]';
	L(2).c      = 0.411785125;

	L(3).A(1,:) = [0.165519272  -0.059559569  0.054169670];
	L(3).A(2,:) = [-0.059559569  0.263486110  -0.052815085];
	L(3).A(3,:) = [0.054169670  -0.052815085  -0.130977316];
	L(3).b      = [0.197695301  -0.154438558  0.267138333]';
	L(3).c      = 0.298012607;

end

%
%
%
function L = do_toys2_atrium_01()

	L(1).A(1,:) = [0.094268131  -0.020305607  0.001574035];
	L(1).A(2,:) = [-0.020305607  0.065244147  -0.008693126];
	L(1).A(3,:) = [0.001574035  -0.008693126  -0.114655858];
	L(1).b      = [0.038602904  -0.111551688  0.141321378]';
	L(1).c      = 0.535252958;

	L(2).A(1,:) = [0.198313605  -0.043456870  0.021136599];
	L(2).A(2,:) = [-0.043456870  0.212165627  -0.024597662];
	L(2).A(3,:) = [0.021136599  -0.024597662  -0.070718558];
	L(2).b      = [0.116818006  -0.134384895  0.208334567]';
	L(2).c      = 0.342049186;

	L(3).A(1,:) = [0.164920818  -0.059984321  0.053951945];
	L(3).A(2,:) = [-0.059984321  0.262137437  -0.053249998];
	L(3).A(3,:) = [0.053951945  -0.053249998  -0.128341402];
	L(3).b      = [0.197958646  -0.153626681  0.262530828]';
	L(3).c      = 0.300210924;

end


%
%
%
function L = do_toys2_atrium_old()

	L(1).A(1,:) = [0.139893599  -0.020290070  0.001618002];
	L(1).A(2,:) = [-0.020290070  0.110964998  -0.008640002];
	L(1).A(3,:) = [0.001618002  -0.008640002  -0.069039329];
	L(1).b      = [0.038681095  -0.111621729  0.141343398]';
	L(1).c      = 0.489607989;

	L(2).A(1,:) = [0.162516697  -0.043418558  0.021191179];
	L(2).A(2,:) = [-0.043418558  0.176704288  -0.024601449];
	L(2).A(3,:) = [0.021191179  -0.024601449  -0.106610991];
	L(2).b      = [0.116906596  -0.134454088  0.208582093]';
	L(2).c      = 0.377651269;

	L(3).A(1,:) = [0.166138653  -0.059895262  0.054083402];
	L(3).A(2,:) = [-0.059895262  0.264195258  -0.053474452];
	L(3).A(3,:) = [0.054083402  -0.053474452  -0.127696555];
	L(3).b      = [0.197930362  -0.153533424  0.263525858]';
	L(3).c      = 0.298423619;

end



%
%
%
function L = do_matte1()

	L(1).A(1,:) = [-0.006782460  0.019861968  -0.014963590];
	L(1).A(2,:) = [0.019861968  0.006678311  -0.021031480];
	L(1).A(3,:) = [-0.014963590  -0.021031480  0.095496668];
	L(1).b      = [-0.272928498  -0.361880191  0.472788023]';
	L(1).c      = 0.234103485;

end



function L = do_doge2()

	L(1).A(1,:) = [0.015830838  0.009863350  -0.008441639];
	L(1).A(2,:) = [0.009863350  0.100400810  -0.030425494];
	L(1).A(3,:) = [-0.008441639  -0.030425494  0.023314615];
	L(1).b      = [-0.048729667  -0.263370345  -0.012635257]';
	L(1).c      = 0.625679240;

	L(2).A(1,:) = [0.072559897  0.008869489  -0.008456507];
	L(2).A(2,:) = [0.008869489  0.153629594  -0.031493164];
	L(2).A(3,:) = [-0.008456507  -0.031493164  0.082064418];
	L(2).b      = [-0.049063078  -0.273123424  -0.015279968]';
	L(2).c      = 0.546068837;

	L(3).A(1,:) = [0.083066117  0.007930685  -0.008944068];
	L(3).A(2,:) = [0.007930685  0.161190677  -0.032789159];
	L(3).A(3,:) = [-0.008944068  -0.032789159  0.095240018];
	L(3).b      = [-0.050833394  -0.290998635  -0.017568067]';
	L(3).c      = 0.527343880;

end

function L = do_ennis2()

	L(1).A(1,:) = [0.080762376  0.011849473  0.009382014];
	L(1).A(2,:) = [0.011849473  0.111858901  -0.007299025];
	L(1).A(3,:) = [0.009382014  -0.007299025  0.230878551];
	L(1).b      = [-0.427965986  -0.022387966  0.108042296]';
	L(1).c      = 0.422880039;

	L(2).A(1,:) = [0.071753533  0.004175100  0.028406833];
	L(2).A(2,:) = [0.004175100  0.117032178  -0.002446151];
	L(2).A(3,:) = [0.028406833  -0.002446151  0.211355305];
	L(2).b      = [-0.450758181  -0.042637971  0.158663412]';
	L(2).c      = 0.399524850;

	L(3).A(1,:) = [0.068917694  -0.004128130  0.052753345];
	L(3).A(2,:) = [-0.004128130  0.129539105  0.004087538];
	L(3).A(3,:) = [0.052753345  0.004087538  0.187198607];
	L(3).b      = [-0.486253632  -0.071392795  0.237439409]';
	L(3).c      = 0.388782166;

end

function L = do_galileo2()

	L(1).A(1,:) = [0.240564806  -0.047905742  0.034538094];
	L(1).A(2,:) = [-0.047905742  0.129397473  -0.012716145];
	L(1).A(3,:) = [0.034538094  -0.012716145  0.123942703];
	L(1).b      = [0.199785944  -0.118386499  0.080303998]';
	L(1).c      = 0.498419201;

	L(2).A(1,:) = [0.211633991  -0.043085961  0.030439850];
	L(2).A(2,:) = [-0.043085961  0.111374559  -0.011011910];
	L(2).A(3,:) = [0.030439850  -0.011011910  0.104246524];
	L(2).b      = [0.179990256  -0.107634181  0.081651054]';
	L(2).c      = 0.431536271;

	L(3).A(1,:) = [0.127028657  -0.046355305  0.033600202];
	L(3).A(2,:) = [-0.046355305  0.027580207  -0.012069118];
	L(3).A(3,:) = [0.033600202  -0.012069118  0.018375447];
	L(3).b      = [0.192358243  -0.110186873  0.079769713]';
	L(3).c      = 0.493616856;

end

function L = do_grace2()

	L(1).A(1,:) = [0.180784095  -0.023972751  -0.051483402];
	L(1).A(2,:) = [-0.023972751  0.112395461  -0.003710746];
	L(1).A(3,:) = [-0.051483402  -0.003710746  0.255425753];
	L(1).b      = [-0.157220522  -0.189310701  -0.021475438]';
	L(1).c      = 0.561461161;

	L(2).A(1,:) = [0.133566758  -0.018141823  -0.027804326];
	L(2).A(2,:) = [-0.018141823  0.083057195  -0.005230388];
	L(2).A(3,:) = [-0.027804326  -0.005230388  0.206710424];
	L(2).b      = [-0.058335112  -0.232799676  -0.022539045]';
	L(2).c      = 0.423493267;

	L(3).A(1,:) = [0.140399079  0.006958744  -0.028204688];
	L(3).A(2,:) = [0.006958744  0.051732064  0.003631872];
	L(3).A(3,:) = [-0.028204688  0.003631872  0.268551188];
	L(3).b      = [0.002180224  -0.406304580  -0.036588613]';
	L(3).c      = 0.460208333;

end

function L = do_hallstatt2()

	L(1).A(1,:) = [0.210301080  -0.003913803  -0.029735023];
	L(1).A(2,:) = [-0.003913803  0.128650400  0.027293540];
	L(1).A(3,:) = [-0.029735023  0.027293540  0.170558633];
	L(1).b      = [0.130902115  -0.154873538  0.087311176]';
	L(1).c      = 0.514354589;

	L(2).A(1,:) = [0.071778879  -0.019692818  -0.021428649];
	L(2).A(2,:) = [-0.019692818  0.012596749  0.035584483];
	L(2).A(3,:) = [-0.021428649  0.035584483  0.054385131];
	L(2).b      = [0.168931360  -0.221440662  0.089584970]';
	L(2).c      = 0.596726505;

	L(3).A(1,:) = [0.062154343  -0.025270867  -0.019929239];
	L(3).A(2,:) = [-0.025270867  0.014020617  0.042003807];
	L(3).A(3,:) = [-0.019929239  0.042003807  0.056610956];
	L(3).b      = [0.196105991  -0.268626456  0.095567110]';
	L(3).c      = 0.604656033;

end

function L = do_pisa2()

	L(1).A(1,:) = [0.118752528  0.008776483  0.020181580];
	L(1).A(2,:) = [0.008776483  0.050368079  0.024594014];
	L(1).A(3,:) = [0.020181580  0.024594014  0.071211567];
	L(1).b      = [-0.037743077  -0.269699754  0.113049719]';
	L(1).c      = 0.644407839;

	L(2).A(1,:) = [0.092346528  0.033378914  0.018831932];
	L(2).A(2,:) = [0.033378914  0.011413047  0.025564946];
	L(2).A(3,:) = [0.018831932  0.025564946  0.036158190];
	L(2).b      = [-0.143050469  -0.246832797  0.014189928]';
	L(2).c      = 0.610221826;

	L(3).A(1,:) = [0.180171821  0.053679076  -0.000929844];
	L(3).A(2,:) = [0.053679076  0.115544481  0.026500960];
	L(3).A(3,:) = [-0.000929844  0.026500960  0.139288251];
	L(3).b      = [-0.227064780  -0.258484658  -0.071108510]';
	L(3).c      = 0.483324351;

end

function L = do_rnl2()

	L(1).A(1,:) = [0.071715796  -0.017897011  -0.007866523];
	L(1).A(2,:) = [-0.017897011  0.020268916  0.023756110];
	L(1).A(3,:) = [-0.007866523  0.023756110  0.053384167];
	L(1).b      = [-0.104571689  -0.253758848  0.056523162]';
	L(1).c      = 0.572552597;

	L(2).A(1,:) = [0.180506340  -0.027514413  -0.006253786];
	L(2).A(2,:) = [-0.027514413  0.129779245  0.029379361];
	L(2).A(3,:) = [-0.006253786  0.029379361  0.165432466];
	L(2).b      = [-0.101572320  -0.300965957  0.067290916]';
	L(2).c      = 0.491736677;

	L(3).A(1,:) = [0.180863125  -0.036017462  -0.003156820];
	L(3).A(2,:) = [-0.036017462  0.133574139  0.033059739];
	L(3).A(3,:) = [-0.003156820  0.033059739  0.169660324];
	L(3).b      = [-0.087038765  -0.342238066  0.077152461]';
	L(3).c      = 0.499970402;

end

function L = do_tunnel2()

	L(1).A(1,:) = [0.226100393  0.031585904  0.025312924];
	L(1).A(2,:) = [0.031585904  0.077823535  0.030131131];
	L(1).A(3,:) = [0.025312924  0.030131131  0.161191584];
	L(1).b      = [-0.260281975  -0.116558664  0.086066939]';
	L(1).c      = 0.480784788;

	L(2).A(1,:) = [0.217824687  0.029428790  0.025272163];
	L(2).A(2,:) = [0.029428790  0.081292294  0.028575076];
	L(2).A(3,:) = [0.025272163  0.028575076  0.167617416];
	L(2).b      = [-0.244246157  -0.104588069  0.077023055]';
	L(2).c      = 0.481804468;

	L(3).A(1,:) = [0.131230626  0.031158083  0.016873870];
	L(3).A(2,:) = [0.031158083  -0.009184573  0.022383781];
	L(3).A(3,:) = [0.016873870  0.022383781  0.058748429];
	L(3).b      = [-0.211350369  -0.083144428  0.056962099]';
	L(3).c      = 0.521132298;

end

function L = do_uffizi2()

	L(1).A(1,:) = [0.064708809  -0.003160239  -0.061734458];
	L(1).A(2,:) = [-0.003160239  0.230780858  0.002604768];
	L(1).A(3,:) = [-0.061734458  0.002604768  0.128314809];
	L(1).b      = [-0.021110393  -0.336314585  -0.105046873]';
	L(1).c      = 0.423712329;

	L(2).A(1,:) = [0.061655044  -0.003831287  -0.062643992];
	L(2).A(2,:) = [-0.003831287  0.226981486  0.001727204];
	L(2).A(3,:) = [-0.062643992  0.001727204  0.126780885];
	L(2).b      = [-0.021370988  -0.341085055  -0.107228491]';
	L(2).c      = 0.416477949;

	L(3).A(1,:) = [0.063327455  -0.004579530  -0.067977348];
	L(3).A(2,:) = [-0.004579530  0.241037050  -0.000314533];
	L(3).A(3,:) = [-0.067977348  -0.000314533  0.133210212];
	L(3).b      = [-0.023239681  -0.372137596  -0.115345398]';
	L(3).c      = 0.438822269;

end

function L = do_window2()

	L(1).A(1,:) = [0.192350192  0.001331403  -0.004092210];
	L(1).A(2,:) = [0.001331403  0.120355226  0.023918682];
	L(1).A(3,:) = [-0.004092210  0.023918682  0.190089084];
	L(1).b      = [-0.271409126  -0.076116510  0.059122094]';
	L(1).c      = 0.507060223;

	L(2).A(1,:) = [0.157214474  0.014388266  0.011215566];
	L(2).A(2,:) = [0.014388266  0.110138111  0.025754332];
	L(2).A(3,:) = [0.011215566  0.025754332  0.165569704];
	L(2).b      = [-0.321938250  -0.117946972  0.074158017]';
	L(2).c      = 0.447194421;

	L(3).A(1,:) = [0.137931088  0.024486759  0.020553580];
	L(3).A(2,:) = [0.024486759  0.113127271  0.027798802];
	L(3).A(3,:) = [0.020553580  0.027798802  0.153789027];
	L(3).b      = [-0.346288507  -0.158605105  0.091940688]';
	L(3).c      = 0.404445085;

end

function L = do_toys4_set7()

	L(1).A(1,:) = [0.020539979  -0.008839013  0.001371363];
	L(1).A(2,:) = [-0.008839013  0.011939445  -0.047621556];
	L(1).A(3,:) = [0.001371363  -0.047621556  0.004040222];
	L(1).b      = [-0.027016974  -0.163064371  0.166674222]';
	L(1).c      = 0.592503269;

	L(2).A(1,:) = [0.083809294  0.002850376  -0.023655909];
	L(2).A(2,:) = [0.002850376  0.019675196  -0.086158495];
	L(2).A(3,:) = [-0.023655909  -0.086158495  -0.002504628];
	L(2).b      = [-0.100604874  -0.187720149  0.208910271]';
	L(2).c      = 0.380821872;

	L(3).A(1,:) = [0.165010797  -0.003564602  -0.057282508];
	L(3).A(2,:) = [-0.003564602  0.036844283  -0.094187186];
	L(3).A(3,:) = [-0.057282508  -0.094187186  -0.020956238];
	L(3).b      = [-0.215660391  -0.177421659  0.247707359]';
	L(3).c      = 0.299353758;

end

function L = do_toys4_set4()

	L(1).A(1,:) = [-0.008227806  0.008849929  -0.001033386];
	L(1).A(2,:) = [0.008849929  0.048945241  -0.057227028];
	L(1).A(3,:) = [-0.001033386  -0.057227028  0.021247751];
	L(1).b      = [-0.050917746  -0.077071977  0.098969812]';
	L(1).c      = 0.573446503;

	L(2).A(1,:) = [0.031868535  0.030334067  -0.042208212];
	L(2).A(2,:) = [0.030334067  0.034992811  -0.082194634];
	L(2).A(3,:) = [-0.042208212  -0.082194634  0.008024606];
	L(2).b      = [-0.121715971  -0.139824590  0.137688187]';
	L(2).c      = 0.430551102;

	L(3).A(1,:) = [0.135884310  0.038566870  -0.097400893];
	L(3).A(2,:) = [0.038566870  0.072974536  -0.104407030];
	L(3).A(3,:) = [-0.097400893  -0.104407030  0.105908899];
	L(3).b      = [-0.216373428  -0.181703425  0.108650960]';
	L(3).c      = 0.315646170;

end

function L = do_toys4_set1()

	L(1).A(1,:) = [0.023046859  0.007448873  0.010064224];
	L(1).A(2,:) = [0.007448873  0.062042825  -0.057962214];
	L(1).A(3,:) = [0.010064224  -0.057962214  -0.015212089];
	L(1).b      = [0.004681073  -0.166201313  0.081265180]';
	L(1).c      = 0.551113335;

	L(2).A(1,:) = [0.003100578  -0.015337563  0.037242865];
	L(2).A(2,:) = [-0.015337563  0.058514832  -0.093816272];
	L(2).A(3,:) = [0.037242865  -0.093816272  0.022210127];
	L(2).b      = [0.064588757  -0.245895110  0.080028001]';
	L(2).c      = 0.444514537;

	L(3).A(1,:) = [0.050947342  -0.008317676  0.048092147];
	L(3).A(2,:) = [-0.008317676  0.104144377  -0.105218521];
	L(3).A(3,:) = [0.048092147  -0.105218521  0.197932403];
	L(3).b      = [0.164727979  -0.344672369  0.024044550]';
	L(3).c      = 0.353126861;

end

function L = do_toys5_set1()

	L(1).A(1,:) = [0.098222609  0.024343062  -0.005797531];
	L(1).A(2,:) = [0.024343062  0.067858837  -0.033120765];
	L(1).A(3,:) = [-0.005797531  -0.033120765  0.214387167];
	L(1).b      = [0.088311456  -0.143007831  -0.002385997]';
	L(1).c      = 0.499749133;

	L(2).A(1,:) = [0.126363852  0.015018165  0.044977997];
	L(2).A(2,:) = [0.015018165  0.059487347  -0.058430604];
	L(2).A(3,:) = [0.044977997  -0.058430604  0.201679452];
	L(2).b      = [0.151775901  -0.144281309  0.001203750]';
	L(2).c      = 0.388689154;

	L(3).A(1,:) = [0.114546231  0.012971176  0.102037168];
	L(3).A(2,:) = [0.012971176  0.051214803  -0.081043402];
	L(3).A(3,:) = [0.102037168  -0.081043402  0.208253431];
	L(3).b      = [0.225426777  -0.128399875  -0.032242357]';
	L(3).c      = 0.374891558;

end

function L = do_window03_gray()

	L(1).A(1,:) = [0.046455710  0.006203751  0.006654198];
	L(1).A(2,:) = [0.006203751  -0.019450006  0.009762319];
	L(1).A(3,:) = [0.006654198  0.009762319  0.031807688];
	L(1).b      = [0.104421124  -0.039831673  0.184706553]';
	L(1).c      = 0.531119463;

	L(2).A(1,:) = [0.050084822  0.002887896  0.001182200];
	L(2).A(2,:) = [0.002887896  -0.016146001  0.010126080];
	L(2).A(3,:) = [0.001182200  0.010126080  0.022853611];
	L(2).b      = [0.110710499  -0.081510119  0.237727231]';
	L(2).c      = 0.498681004;

	L(3).A(1,:) = [0.055165575  0.000173747  -0.001270088];
	L(3).A(2,:) = [0.000173747  -0.016643183  0.014002949];
	L(3).A(3,:) = [-0.001270088  0.014002949  0.023167791];
	L(3).b      = [0.112616119  -0.131091904  0.263217160]';
	L(3).c      = 0.480476774;

end

function L = do_tunnel04_gray()

	L(1).A(1,:) = [0.185641866  -0.005773610  0.014544546];
	L(1).A(2,:) = [-0.005773610  0.093698074  0.011739008];
	L(1).A(3,:) = [0.014544546  0.011739008  0.126171737];
	L(1).b      = [0.071910029  -0.086133580  0.314578476]';
	L(1).c      = 0.419881938;

	L(2).A(1,:) = [0.186535317  -0.005807183  0.016829122];
	L(2).A(2,:) = [-0.005807183  0.093108643  0.009737069];
	L(2).A(3,:) = [0.016829122  0.009737069  0.136137016];
	L(2).b      = [0.067381121  -0.079667943  0.289588080]';
	L(2).c      = 0.431418305;

	L(3).A(1,:) = [0.179385530  -0.002418013  0.010344007];
	L(3).A(2,:) = [-0.002418013  0.099647595  0.010395836];
	L(3).A(3,:) = [0.010344007  0.010395836  0.125048730];
	L(3).b      = [0.064635784  -0.067772197  0.310555637]';
	L(3).c      = 0.423183363;

end

function L = do_ps3_sfs()

	L(1).A(1,:) = [-0.076816491  0.000065549  -0.000158351];
	L(1).A(2,:) = [0.000065549  0.314440100  -0.133328683];
	L(1).A(3,:) = [-0.000158351  -0.133328683  -0.040869696];
	L(1).b      = [0.000117629  -0.428984308  0.087536167]';
	L(1).c      = 0.197325763;

	L(2).A(1,:) = [0.119873629  0.195623882  0.094523663];
	L(2).A(2,:) = [0.195623882  0.119678392  0.093951492];
	L(2).A(3,:) = [0.094523663  0.093951492  -0.045758053];
	L(2).b      = [0.303140692  0.303665208  0.095027462]';
	L(2).c      = 0.194214317;

	L(3).A(1,:) = [0.120173856  -0.195634029  -0.094408025];
	L(3).A(2,:) = [-0.195634029  0.119592702  0.094232694];
	L(3).A(3,:) = [-0.094408025  0.094232694  -0.046537448];
	L(3).b      = [-0.303348715  0.303284404  0.096445435]';
	L(3).c      = 0.193648833;

end

%
%
%
function L = do_headlight()

	L(1).A(1,:) = [-0.000001926  0.000001793  -0.000051668];
	L(1).A(2,:) = [0.000001793  0.000002288  -0.000057040];
	L(1).A(3,:) = [-0.000051668  -0.000057040  0.099602283];
	L(1).b      = [0.000109661  0.000140881  0.627690834]';
	L(1).c      = 0.246556075;

end

function L = do_toys5_set2()

	L(1).A(1,:) = [0.002759227  -0.005838796  0.005948802];
	L(1).A(2,:) = [-0.005838796  0.036390612  -0.038411600];
	L(1).A(3,:) = [0.005948802  -0.038411600  0.106834438];
	L(1).b      = [-0.089231571  -0.329493144  0.064264020]';
	L(1).c      = 0.448548327;

	L(2).A(1,:) = [0.019351062  -0.001836424  0.010092678];
	L(2).A(2,:) = [-0.001836424  0.104863572  -0.052349231];
	L(2).A(3,:) = [0.010092678  -0.052349231  0.147501287];
	L(2).b      = [-0.112915545  -0.353574056  0.091391916]';
	L(2).c      = 0.358211689;

	L(3).A(1,:) = [0.002805400  0.008936618  0.008425007];
	L(3).A(2,:) = [0.008936618  0.119372044  -0.053443270];
	L(3).A(3,:) = [0.008425007  -0.053443270  0.096732945];
	L(3).b      = [-0.095080028  -0.345507454  0.133748116]';
	L(3).c      = 0.265874300;

end

function L = do_matte_top_gray()

	L(1).A(1,:) = [-0.091360374  -0.000000637  -0.000037694];
	L(1).A(2,:) = [-0.000000637  0.100698855  -0.168775062];
	L(1).A(3,:) = [-0.000037694  -0.168775062  0.235312168];
	L(1).b      = [0.000074519  -0.428763057  0.050552318]';
	L(1).c      = 0.309052199;

end

function L = do_toys5_set3()

	L(1).A(1,:) = [0.131388347  0.006322841  -0.132423786];
	L(1).A(2,:) = [0.006322841  0.021078110  -0.024001958];
	L(1).A(3,:) = [-0.132423786  -0.024001958  0.221903620];
	L(1).b      = [-0.226573253  -0.028855772  -0.012758748]';
	L(1).c      = 0.375337116;

	L(2).A(1,:) = [0.132434086  0.006123656  -0.134404692];
	L(2).A(2,:) = [0.006123656  -0.001442843  -0.020104480];
	L(2).A(3,:) = [-0.134404692  -0.020104480  0.186125322];
	L(2).b      = [-0.221411358  -0.054556655  0.011441464]';
	L(2).c      = 0.317705909;

	L(3).A(1,:) = [0.127421040  0.005557219  -0.135189038];
	L(3).A(2,:) = [0.005557219  -0.018619148  -0.015103098];
	L(3).A(3,:) = [-0.135189038  -0.015103098  0.159762212];
	L(3).b      = [-0.226945074  -0.078800447  0.028923642]';
	L(3).c      = 0.268916557;

end


function L = do_toys5_set4()

	L(1).A(1,:) = [0.213981275  0.005591109  0.033060863];
	L(1).A(2,:) = [0.005591109  0.167609049  -0.010326571];
	L(1).A(3,:) = [0.033060863  -0.010326571  0.008969144];
	L(1).b      = [0.125051928  -0.023445515  0.190047134]';
	L(1).c      = 0.411559751;

	L(2).A(1,:) = [0.202474246  -0.001230174  0.038630586];
	L(2).A(2,:) = [-0.001230174  0.123711519  0.001834454];
	L(2).A(3,:) = [0.038630586  0.001834454  0.023282143];
	L(2).b      = [0.159911578  -0.017108266  0.153959195]';
	L(2).c      = 0.353942636;

	L(3).A(1,:) = [0.183471146  -0.008248832  0.037756314];
	L(3).A(2,:) = [-0.008248832  0.070034200  0.011510806];
	L(3).A(3,:) = [0.037756314  0.011510806  0.011532450];
	L(3).b      = [0.188901393  -0.011502865  0.131484396]';
	L(3).c      = 0.266490033;

end


